<?php

declare(strict_types=1);

namespace Atlas\AuditBundle\Tests\DependencyInjection;

use Atlas\AuditBundle\DependencyInjection\AuditExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

final class AuditExtensionPrependTest extends TestCase
{
    public function testPrependAddsMappingsWhenNoEntityManagersDefined(): void
    {
        $container = new ContainerBuilder();

        // Simulate "simple" doctrine config with no entity_managers
        $container->prependExtensionConfig('doctrine', [
            'orm' => [
                // no entity_managers
            ],
        ]);

        (new AuditExtension())->prepend($container);

        $configs = $container->getExtensionConfig('doctrine');

        $flattened = array_merge_recursive(...$configs);

        self::assertArrayHasKey('orm', $flattened);
        self::assertArrayHasKey('mappings', $flattened['orm']);
        self::assertArrayHasKey('AtlasAudit', $flattened['orm']['mappings']);
        self::assertSame('attribute', $flattened['orm']['mappings']['AtlasAudit']['type']);
    }

    public function testPrependAddsMappingsOnlyToDefaultEntityManager(): void
    {
        $container = new ContainerBuilder();

        $container->prependExtensionConfig('doctrine', [
            'orm' => [
                'default_entity_manager' => 'phoenix',
                'entity_managers' => [
                    'phoenix' => [],
                    'other' => [],
                ],
            ],
        ]);

        (new AuditExtension())->prepend($container);

        $configs = $container->getExtensionConfig('doctrine');
        $flattened = array_merge_recursive(...$configs);

        self::assertArrayHasKey('entity_managers', $flattened['orm']);
        self::assertArrayHasKey('phoenix', $flattened['orm']['entity_managers']);
        self::assertArrayHasKey('mappings', $flattened['orm']['entity_managers']['phoenix']);
        self::assertArrayHasKey('AtlasAudit', $flattened['orm']['entity_managers']['phoenix']['mappings']);

        // Ensure we didn't also attach to "other"
        self::assertArrayNotHasKey(
            'mappings',
            $flattened['orm']['entity_managers']['other'] ?? []
        );
    }
}
