<?php

declare(strict_types=1);

namespace Atlas\AuditBundle\Tests\Attribute;

use Atlas\AuditBundle\Attribute\AuditActor;
use Atlas\AuditBundle\Attribute\AuditTimestamp;
use Atlas\AuditBundle\Attribute\NotLogged;
use Atlas\AuditBundle\Attribute\Enum\AuditActionType;
use PHPUnit\Framework\TestCase;
use ReflectionClass;
use Attribute as PhpAttribute;

final class AttributeTest extends TestCase
{
    public function testAttributesAreDeclaredAsAttributes(): void
    {
        foreach ([AuditActor::class, AuditTimestamp::class, NotLogged::class] as $cls) {
            $ref = new ReflectionClass($cls);
            self::assertNotEmpty($ref->getAttributes(PhpAttribute::class), $cls.' missing #[Attribute]');
        }
    }

    public function testAuditActorHoldsAction(): void
    {
        $a = new AuditActor(AuditActionType::INSERT);
        self::assertSame(AuditActionType::INSERT, $a->action);
    }

    public function testAuditTimestampHoldsAction(): void
    {
        $t = new AuditTimestamp(AuditActionType::UPDATE);
        self::assertSame(AuditActionType::UPDATE, $t->action);
    }

    public function testEnumValuesAreStable(): void
    {
        self::assertSame('I', AuditActionType::INSERT->value);
        self::assertSame('U', AuditActionType::UPDATE->value);
        self::assertSame('D', AuditActionType::DELETE->value);
    }
}
