<?php

declare(strict_types=1);

namespace Atlas\AuditBundle\Repository;

use Atlas\AuditBundle\Entity\System;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;

/**
 * Repository for audit_system entries.
 */
final class SystemRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, System::class);
    }

    /**
     * Query audits for a subject (table + identifier), newest first.
     *
     * @param string $table_name
     * @param int $identifier
     * @return QueryBuilder
     */
    public function findForSubjectQueryBuilder(string $table_name, int $identifier): QueryBuilder
    {
        return $this->createQueryBuilder('a')
            ->andWhere('a.table_name = :table_name')
            ->andWhere('a.identifier = :identifier')
            ->setParameter('table_name', $table_name)
            ->setParameter('identifier', $identifier)
            ->orderBy('a.timestamp', 'DESC')
            ->addOrderBy('a.id', 'DESC');
    }
}
