<?php

declare(strict_types=1);

namespace Atlas\ExportBundle\Service;

/**
 * Converts row values into scalar/strings suitable for exports.
 */
final class RowNormaliser
{
    /**
     * @param array<int, array<string, mixed>> $rows
     * @return array<int, array<string, scalar|null>>
     */
    public function normaliseRows(array $rows): array
    {
        return array_map(fn(array $row) => $this->normaliseRow($row), $rows);
    }

    /**
     * @param array<string, mixed> $row
     * @return array<string, scalar|null>
     */
    public function normaliseRow(array $row): array
    {
        foreach ($row as $k => $v) {
            $row[$k] = $this->normaliseCell($v);
        }

        /** @var array<string, scalar|null> $row */
        return $row;
    }

    /**
     * @return scalar|null
     */
    private function normaliseCell(mixed $value): mixed
    {
        if ($value === null || is_string($value) || is_int($value) || is_float($value)) {
            return $value;
        }

        if (is_bool($value)) {
            return $value ? 1 : 0;
        }

        if ($value instanceof \DateTimeInterface) {
            return $value->format('Y-m-d H:i:s');
        }

        // last resort – avoid fatal in fputcsv / TSV / cell setters
        return (string) $value;
    }
}