<?php

declare(strict_types=1);

namespace Atlas\ExportBundle\Service;

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;

final readonly class SpreadsheetBuilder
{
    public function buildXlsx(array $rows): string
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        if ($rows === []) {
            $writer = new Xlsx($spreadsheet);
            return $this->asBinary($writer);
        }

        $headers = array_keys($rows[0]);

        // 1. headers
        foreach ($headers as $colIndex => $headerLabel) {
            $columnLetter = Coordinate::stringFromColumnIndex($colIndex + 1);
            $sheet->setCellValue("{$columnLetter}1", $headerLabel);
        }

        // 2. data
        $rowNumber = 2;
        foreach ($rows as $row) {
            foreach ($headers as $colIndex => $headerKey) {
                $columnLetter = Coordinate::stringFromColumnIndex($colIndex + 1);
                $value = $row[$headerKey] ?? null;
                $sheet->setCellValue("{$columnLetter}{$rowNumber}", $value);
            }
            $rowNumber++;
        }

        // autosize
        foreach (range(1, count($headers)) as $colIndex) {
            $columnLetter = Coordinate::stringFromColumnIndex($colIndex);
            $sheet->getColumnDimension($columnLetter)->setAutoSize(true);
        }

        $writer = new Xlsx($spreadsheet);
        return $this->asBinary($writer);
    }

    private function asBinary(Xlsx $writer): string
    {
        $handle = fopen('php://temp', 'r+');
        $writer->save($handle);
        rewind($handle);
        $binary = stream_get_contents($handle);
        fclose($handle);

        return $binary === false ? '' : $binary;
    }
}
