<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\Service;

use Atlas\ExportBundle\Service\DownloadResponseFactory;
use PHPUnit\Framework\TestCase;

final class DownloadResponseFactoryTest extends TestCase
{
    public function testMakeSetsHeaders(): void
    {
        $f = new DownloadResponseFactory();
        $r = $f->make('abc', 'file.txt', 'text/plain');

        self::assertSame('text/plain', $r->headers->get('Content-Type'));
        self::assertStringContainsString('attachment', (string) $r->headers->get('Content-Disposition'));
        self::assertSame('3', $r->headers->get('Content-Length'));
    }
}