<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\Service;

use Atlas\ExportBundle\Service\SpssBuilder;
use PHPUnit\Framework\TestCase;
use ZipArchive;

final class SpssBuilderTest extends TestCase
{
    public function testBuildSpssPackageCreatesZipWithExpectedFiles(): void
    {
        $b = new SpssBuilder();

        $pkg = $b->buildSpssPackage(
            dataRows: [
                ['age' => 10, 'group' => 1],
                ['age' => 20, 'group' => 2],
            ],
            variables: [
                ['name' => 'age', 'label' => 'Age', 'type' => 'INTEGER'],
                ['name' => 'group', 'label' => 'Group', 'type' => 'CATEGORY'],
            ],
            categoricalOptions: [
                'group' => ['1' => 'A', '2' => 'B'],
            ],
        );

        self::assertSame('export_spss.zip', $pkg['filename']);
        self::assertSame('application/zip', $pkg['contentType']);
        self::assertNotSame('', $pkg['binary']);

        $tmp = tempnam(sys_get_temp_dir(), 'spss_');
        self::assertNotFalse($tmp);
        file_put_contents($tmp, $pkg['binary']);

        $zip = new ZipArchive();
        self::assertTrue($zip->open($tmp) === true);

        self::assertNotFalse($zip->locateName('data.tsv'));
        self::assertNotFalse($zip->locateName('import.sps'));

        $zip->close();
        @unlink($tmp);
    }
}