<?php

declare(strict_types=1);

namespace Atlas\ExportBundle\Service;

use Symfony\Component\HttpFoundation\Response;

/**
 * Wraps raw binary/text in a HTTP download Response with correct headers.
 */
final readonly class DownloadResponseFactory
{
    public function make(string $binary, string $filename, string $contentType): Response
    {
        $response = new Response($binary);

        $disposition = sprintf('attachment; filename="%s"', $filename);

        $response->headers->set('Content-Type', $contentType);
        $response->headers->set('Content-Disposition', $disposition);
        $response->headers->set('Content-Length', (string) \strlen($binary));

        return $response;
    }
}
