<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\DependencyInjection;

use Atlas\ExportBundle\DependencyInjection\ExportExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

final class ExportExtensionTest extends TestCase
{
    public function testExtensionLoadsServicesYaml(): void
    {
        $container = new ContainerBuilder();
        $extension = new ExportExtension();

        $extension->load([], $container);

        $defs = array_keys($container->getDefinitions());

        $found = false;
        foreach ($defs as $id) {
            if (str_starts_with($id, 'Atlas\\ExportBundle\\')) {
                $found = true;
                break;
            }
        }

        self::assertTrue(
            $found,
            'ExportExtension did not load any Atlas\\ExportBundle\\ services. Check config/services.yaml resource/exclude and that symfony/yaml is installed (require-dev).'
        );
    }
}