<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\Service;

use Atlas\ExportBundle\Service\CsvBuilder;
use PHPUnit\Framework\TestCase;

final class CsvBuilderTest extends TestCase
{
    public function testBuildCsvAddsBomAndHeadersAndRows(): void
    {
        $b = new CsvBuilder();

        $csv = $b->buildCsv([
            ['a' => 1, 'b' => 'x'],
            ['a' => 2, 'b' => 'y'],
        ]);

        self::assertNotSame('', $csv);
        self::assertTrue(str_starts_with($csv, "\xEF\xBB\xBF"), 'CSV should start with UTF-8 BOM');

        $noBom = substr($csv, 3);
        self::assertStringContainsString("a,b\n", $noBom);
        self::assertStringContainsString("1,x\n", $noBom);
        self::assertStringContainsString("2,y\n", $noBom);
    }

    public function testBuildCsvWithEmptyRowsReturnsString(): void
    {
        $b = new CsvBuilder();
        $csv = $b->buildCsv([]);

        self::assertIsString($csv);
    }
}