<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\Service;

use Atlas\ExportBundle\Service\SpreadsheetBuilder;
use PHPUnit\Framework\TestCase;

final class SpreadsheetBuilderTest extends TestCase
{
    public function testBuildXlsxReturnsZipBinary(): void
    {
        $b = new SpreadsheetBuilder();
        $bin = $b->buildXlsx([['a' => 1]]);

        self::assertNotSame('', $bin);
        self::assertSame('PK', substr($bin, 0, 2));
    }
}