<?php
declare(strict_types=1);

namespace Atlas\ExportBundle\Tests\Service;

use Atlas\ExportBundle\Service\SpssFormSpecificationCompiler;
use PHPUnit\Framework\TestCase;

final class SpssFormSpecificationCompilerTest extends TestCase
{
    public function testCompileBuildsVariablesAndCategoricalOptions(): void
    {
        $c = new SpssFormSpecificationCompiler();

        $spec = [
            'elements' => [
                ['spec' => [
                    'name' => 'age',
                    'type' => 'integer',
                    'options' => ['label' => 'Age'],
                    'attributes' => ['missing-code' => '-9'],
                ]],
                ['spec' => [
                    'name' => 'consent',
                    'type' => 'yesno',
                    'options' => ['label' => 'Consent'],
                ]],
                ['spec' => [
                    'name' => 'group',
                    'type' => 'category',
                    'options' => [
                        'label' => 'Group',
                        'value_options' => ['1' => 'A', '2' => 'B'],
                    ],
                ]],
            ],
        ];

        $out = $c->compile($spec);

        self::assertArrayHasKey('variables', $out);
        self::assertArrayHasKey('categoricalOptions', $out);

        $names = array_map(static fn(array $v) => $v['name'], $out['variables']);
        self::assertContains('age', $names);
        self::assertContains('consent', $names);
        self::assertContains('group', $names);

        self::assertSame(['1' => 'Yes', '0' => 'No'], $out['categoricalOptions']['consent']);
        self::assertSame(['1' => 'A', '2' => 'B'], $out['categoricalOptions']['group']);
    }
}