<?php

declare(strict_types=1);

namespace Atlas\ExportBundle\Service;

final readonly class CsvBuilder
{
    /**
     * @param array<array<string, scalar|null>> $rows
     *
     * @return string CSV text (UTF-8 + BOM for Excel friendliness)
     */
    public function buildCsv(array $rows): string
    {
        $handle = fopen('php://temp', 'r+');

        if ($handle === false) {
            // extremely defensive fallback
            return '';
        }

        if ($rows === []) {
            // still emit empty CSV but with no headers
            rewind($handle);
            $csv = stream_get_contents($handle);
            fclose($handle);

            return $csv === false ? '' : $csv;
        }

        // headers from first row keys
        $headers = array_keys($rows[0]);
        fputcsv($handle, $headers);

        // values
        foreach ($rows as $row) {
            $ordered = [];
            foreach ($headers as $h) {
                $ordered[] = $row[$h] ?? null;
            }
            fputcsv($handle, $ordered);
        }

        rewind($handle);
        $csv = stream_get_contents($handle);
        fclose($handle);

        // Prepend UTF-8 BOM so Excel opens UTF-8 nicely.
        $bom = "\xEF\xBB\xBF";

        return $bom . ($csv === false ? '' : $csv);
    }
}
