<?php

declare(strict_types=1);

namespace Atlas\ImpBundle\Entity\Imp;

use Atlas\AuditBundle\Attribute\AuditActor;
use Atlas\AuditBundle\Attribute\AuditTimestamp;
use Atlas\AuditBundle\Attribute\Enum\AuditActionType;
use Atlas\AuditBundle\Attribute\NotLogged;
use Atlas\ImpBundle\Repository\Imp\LevelRepository;
use DateTimeImmutable;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints\Length;
use Symfony\Component\Validator\Constraints\NotBlank;

#[ORM\Entity(repositoryClass: LevelRepository::class)]
#[ORM\UniqueConstraint(columns: ['study_code', 'imp_code','location_code'])]
#[ORM\Table(name: 'imp_level')]
class Level
{

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\Column]
    public string $study_code;

    #[ORM\Column]
    private(set) string $imp_code;

    #[ORM\Column(nullable: true)]
    public ?string $location_code = null;

    #[ORM\Column(nullable: true)]
    private(set) ?int $min = null;

    #[ORM\Column(nullable: true)]
    private(set) ?int $max = null;

    #[NotLogged]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    #[AuditTimestamp(AuditActionType::INSERT)]
    private(set) DateTimeInterface $created;

    #[NotLogged]
    #[ORM\Column(length: 255)]
    #[NotBlank]
    #[AuditActor(AuditActionType::INSERT)]
    private(set) string $created_by;

    #[NotLogged]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    #[AuditTimestamp(AuditActionType::UPDATE)]
    private(set) DateTimeInterface $modified;

    #[NotLogged]
    #[ORM\Column(length: 255)]
    #[NotBlank]
    #[AuditActor(AuditActionType::UPDATE)]
    private(set) string $modified_by;

    #[NotLogged]
    #[ORM\Column(length: 255)]
    #[Length(min: 10, max: 255)]
    private(set) string $reason;

    /**
     * @param string $studyCode
     * @param string $impCode
     * @param string $actionBy
     * @param string|null $locationCode
     * @param int|null $min
     * @param int|null $max
     */
    public function __construct(
        string $studyCode,
        string $impCode,
        string $actionBy,
        ?string $locationCode = null,
        ?int $min = null,
        ?int $max = null
    ) {
        $this->study_code = $studyCode;
        $this->imp_code = $impCode;
        $this->location_code = $locationCode;
        $this->min = $min;
        $this->max = $max;
        $this->created_by = $this->modified_by = $actionBy;
        $this->created = $this->modified = new DateTimeImmutable();
        $this->reason = 'Initial creation of levels';
    }
}
