<?php
declare(strict_types=1);

namespace Atlas\ImpBundle\Exception;

use Throwable;

final class ActivateException extends BundleException
{
    public function __construct(string $message = 'Could not complete the activation or deactivation', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function forResource(string $type, bool $lock): self
    {
        return new self(sprintf($lock ? '%s is already activated' : '%s is already deactivated', $type));
    }
}
