<?php

namespace Atlas\ImpBundle\Domain;

use Atlas\ImpBundle\Exception\SpecificationException;

final readonly class Specification
{
    private(set) string $imp_code;
    private(set) string $allocation_var;
    private(set) AllocationConfiguration $configuration;

    /** @var AlgorithmVariable[] */
    private(set) array $variables;


    public function __construct(
        string $impCode,
        string $allocationVar,
        array $allocations,
        array $variables,
    )
    {

        $impCode = mb_trim($impCode, encoding: 'UTF-8');
        if ($impCode === '') {
            throw new SpecificationException('imp_code must not be empty');
        }

        $this->imp_code = $impCode;

        $allocationVar = mb_trim($allocationVar, encoding: 'UTF-8');
        if ($allocationVar === '') {
            throw new SpecificationException('allocation_var must not be empty');
        }

        $this->allocation_var = $allocationVar;

        if($allocations === []){
            throw new SpecificationException('allocations[] configuration must not be empty');
        }

        if(! isset($allocations['method'])){
            throw new SpecificationException('allocations.method must not be empty');
        }

        if(! isset($allocations['status'])){
            throw new SpecificationException('allocations.status must not be empty');
        }

        if(! isset($allocations['location'])){
            throw new SpecificationException('allocations.location must not be empty');
        }

        $this->configuration = new AllocationConfiguration($allocations['method'], $allocations['status'], $allocations['location']);

        $vars = [];

        foreach($variables as $key => $variable){
            if($variable === []){
                throw new SpecificationException(sprintf('variables[%s] configuration must not be empty', $key));
            }

            if(! isset($variable['name'])){
                throw new SpecificationException(sprintf('variables[%s].name must not be empty', $key));
            }

            if(! isset($variable['variable'])){
                throw new SpecificationException(sprintf('variables[%s].variable must not be empty', $key));
            }

            $vars[] = new AlgorithmVariable($variable['name'], $variable['variable'], $variable['required'] ?? false, $key);
        }

        $this->variables = $vars;
    }
}