<?php

declare(strict_types=1);

namespace Atlas\ImpBundle\Entity\Allocation;

use Atlas\AuditBundle\Attribute\AuditActor;
use Atlas\AuditBundle\Attribute\AuditTimestamp;
use Atlas\AuditBundle\Attribute\Enum\AuditActionType;
use Atlas\ImpBundle\Repository\Allocation\BlockRepository;
use DateTimeImmutable;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: BlockRepository::class)]
#[ORM\Table(name: 'imp_block_block')]
class Block
{

    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\Column]
    private(set) string $study_code;

    #[ORM\Column]
    private(set) string $imp_code;

    #[ORM\Column(length: 255, nullable: true)]
    private(set) ?string $name = null;

    #[ORM\Column(type: Types::BOOLEAN)]
    private(set) bool $active = true;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_1 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_2 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_3 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_4 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_5 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_6 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_7 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_8 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_9 = null;

    #[ORM\Column(type: Types::INTEGER, nullable: true)]
    private(set) ?int $var_10 = null;

    #[AuditTimestamp(AuditActionType::INSERT)]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private(set) DateTimeInterface $added;

    #[AuditActor(AuditActionType::INSERT)]
    #[ORM\Column(length: 255)]
    private(set) string $added_by;

    /**
     * @param string $studyCode
     * @param string $impCode
     * @param string $addedBy
     * @param string|null $name
     * @param bool $active
     * @param int|null $var1
     * @param int|null $var2
     * @param int|null $var3
     * @param int|null $var4
     * @param int|null $var5
     * @param int|null $var6
     * @param int|null $var7
     * @param int|null $var8
     * @param int|null $var9
     * @param int|null $var10
     * @param DateTimeInterface|null $timestamp
     */
    public function __construct(
        string $studyCode,
        string $impCode,
        string $addedBy,
        ?string $name = null,
        bool $active = true,
        ?int $var1 = null,
        ?int $var2 = null,
        ?int $var3 = null,
        ?int $var4 = null,
        ?int $var5 = null,
        ?int $var6 = null,
        ?int $var7 = null,
        ?int $var8 = null,
        ?int $var9 = null,
        ?int $var10 = null,
        ?DateTimeInterface $timestamp = null
    ) {
        $this->study_code = $studyCode;
        $this->imp_code = $impCode;
        $this->name = $name;
        $this->active = $active;
        $this->added_by = $addedBy;
        $this->added = $timestamp ?? new DateTimeImmutable();
        $this->var_1 = $var1;
        $this->var_2 = $var2;
        $this->var_3 = $var3;
        $this->var_4 = $var4;
        $this->var_5 = $var5;
        $this->var_6 = $var6;
        $this->var_7 = $var7;
        $this->var_8 = $var8;
        $this->var_9 = $var9;
        $this->var_10 = $var10;
    }
}
