<?php

declare(strict_types=1);

namespace Atlas\ImpBundle\Entity\Allocation;

use Atlas\AuditBundle\Attribute\AuditActor;
use Atlas\AuditBundle\Attribute\AuditTimestamp;
use Atlas\AuditBundle\Attribute\Enum\AuditActionType;
use Atlas\ImpBundle\Entity\Imp\Pack;
use Atlas\ImpBundle\Repository\Allocation\SequenceRepository;
use DateTimeImmutable;
use DateTimeInterface;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity(repositoryClass: SequenceRepository::class)]
#[ORM\Table(name: 'imp_block_sequence')]
class Sequence
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    private(set) ?int $id = null;

    #[ORM\Column]
    private(set) string $study_code;

    #[ORM\Column]
    private(set) string $imp_code;

    #[ORM\Column(nullable: true)]
    private(set) ?string $location_code = null;

    #[ORM\ManyToOne(targetEntity: Block::class)]
    #[ORM\JoinColumn(name: 'block_id', referencedColumnName: 'id', nullable: false)]
    private(set) Block $block;

    #[ORM\Column]
    private(set) int $sequence;

    #[ORM\OneToOne(targetEntity: Pack::class)]
    #[ORM\JoinColumn(name: 'pack_id', referencedColumnName: 'id', unique: true, nullable: false)]
    private(set) Pack $pack;

    #[AuditTimestamp(AuditActionType::INSERT)]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE)]
    private(set) DateTimeInterface $added;

    #[AuditActor(AuditActionType::INSERT)]
    #[ORM\Column(length: 255)]
    private(set) string $added_by;

    #[AuditActor(AuditActionType::UPDATE)]
    #[ORM\Column(type: Types::DATETIME_IMMUTABLE, nullable: true)]
    private(set) ?DateTimeInterface $allocated;

    #[AuditActor(AuditActionType::UPDATE)]
    #[ORM\Column(length: 255, nullable: true)]
    private(set) ?string $allocated_by;

    /**
     * @param string $studyCode
     * @param string $impCode
     * @param Block $block
     * @param Pack $pack
     * @param int $sequence
     * @param string $addedBy
     * @param string|null $locationCode
     */
    public function __construct(
        string $studyCode,
        string $impCode,
        Block $block,
        Pack $pack,
        int $sequence,
        string $addedBy,
        ?string $locationCode = null,
    ) {
        $this->study_code = $studyCode;
        $this->imp_code = $impCode;
        $this->block = $block;
        $this->pack = $pack;
        $this->sequence = $sequence;
        $this->location_code = $locationCode;
        $this->added_by = $addedBy;
        $this->added = new DateTimeImmutable();
    }

    /**
     * @param string $allocatedBy
     * @return void
     */
    public function setAllocated(string $allocatedBy): void
    {
        $this->allocated_by = $allocatedBy;
        $this->allocated = new DateTimeImmutable();
    }
}
