<?php
declare(strict_types=1);

namespace Atlas\ImpBundle\Exception;

use Throwable;

final class ImpNotFoundException extends NotFoundException
{
    public function __construct(string $message = 'IMP not found', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function fromId(int $id): self
    {
        return new self(sprintf('IMP with ID %s not found', $id));
    }

    public static function fromCode(string $code): self
    {
        return new self(sprintf('IMP with code %s not found', $code));
    }
}
