<?php

declare(strict_types=1);

namespace Atlas\ImpBundle\Repository\Study;

use Atlas\ImpBundle\Entity\Study\Imp;
use Atlas\ImpBundle\Exception\ImpNotFoundException;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Imp>
 */
class ImpRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Imp::class);
    }

    /**
     * @param string $code
     * @return Imp
     */
    public function findByCodeOrThrow(string $code): Imp
    {
        $imp = $this->findOneBy(['code' => $code]);
        if ($imp === null) {
            throw ImpNotFoundException::fromCode($code);
        }
        return $imp;
    }

    public function findByCode(string $code): ?Imp
    {
        $code = mb_trim($code, encoding: 'UTF-8');
        if ($code === '') {
            return null;
        }

        //code are always uppercase in the db
        return $this->createQueryBuilder('r')
            ->andWhere('f.code = :code')
            ->setParameter('code', mb_strtoupper($code, encoding: 'UTF-8'))
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
    }
}
