<?php
declare(strict_types=1);

namespace Atlas\ImpBundle\Exception;

use Throwable;

/**
 * Base exception for "not found" errors.
 */
class PackNotFoundException extends NotFoundException
{
    public function __construct(string $message = 'Pack not found', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function fromId(int $participantId): self
    {
        return new self(sprintf('Pack with ID %s not found', $participantId));
    }

    public static function fromPackIdentifier(int $packIdentifier): self
    {
        return new self(sprintf('Pack with Pack Identifier %s not found', $packIdentifier));
    }
}
