<?php

namespace Atlas\ImpBundle\Repository\Allocation\Algorithm\Block;

use Atlas\ImpBundle\Entity\Allocation\Algorithm\Block\Block;
use Atlas\ImpBundle\Entity\Allocation\Allocation;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Allocation>
 */
class BlockRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Block::class);
    }

    public function findMatchingBlocks(
        string $studyCode,
        string $impCode,
        array $variables = []
    ): array {
        $qb = $this->createQueryBuilder('b')
            ->andWhere('b.study_code = :studyCode')
            ->andWhere('b.imp_code = :impCode')
            ->setParameter('studyCode', $studyCode)
            ->setParameter('impCode', $impCode);

        for ($i = 1; $i <= 10; $i++) {
            $key = 'var_' . $i;

            $hasKey = array_key_exists($key, $variables);
            $value  = $hasKey ? $variables[$key] : null;

            if ($hasKey) {

                if ($value !== null) {
                    // condition: (b.var_1 IS NULL OR b.var_1 = :var_1)
                    $qb->andWhere(sprintf('(b.%s IS NULL OR b.%s = :%s)', $key, $key, $key))
                        ->setParameter($key, $value);
                } else {
                    $qb->andWhere(sprintf('b.%s IS NULL', $key));
                }
            }
            else {
                $qb->andWhere(sprintf('b.%s IS NULL', $key));
            }
        }

        return $qb->getQuery()->getResult();
    }
}
