<?php

namespace Atlas\ImpBundle\Service\Imp;

use Atlas\ImpBundle\Dto\PackCountDto;
use Atlas\ImpBundle\Entity\Imp\Enum\PackStatus;
use Atlas\ImpBundle\Entity\Imp\Pack;
use Atlas\ImpBundle\Repository\Imp\PackRepository;
use Doctrine\ORM\EntityManagerInterface;

readonly class PackManager
{
    /**
     * @param EntityManagerInterface $entity_manager
     */
    public function __construct(
        private EntityManagerInterface $entity_manager,
        private PackRepository $packs,
    ) {}


    /**
     * @param Pack $pack
     * @param PackStatus $status
     * @param string $actionBy
     * @return void
     */
    public function updateStatus(Pack $pack, PackStatus $status, string $actionBy): void
    {
        $pack->setReceipt($status, $actionBy);
        $this->entity_manager->flush();
    }

    /**
     * @param Pack $pack
     * @param string $actionBy
     * @return void
     */
    public function in(Pack $pack, string $actionBy): void
    {
        $pack->setIn($actionBy);
        $this->entity_manager->flush();
    }

    /**
     * @param Pack $pack
     * @param string $actionBy
     * @return void
     */
    public function out(Pack $pack, string $actionBy): void
    {
        $pack->setout($actionBy);
        $this->entity_manager->flush();
    }

    /**
     * @param Pack $pack
     * @param string $actionBy
     * @return void
     */
    public function dispense(Pack $pack, string $actionBy): void
    {
        $pack->setDispense($actionBy);
        $this->entity_manager->flush();
    }

    /**
     * @param Pack $pack
     * @param string $actionBy
     * @return void
     */
    public function destroy(Pack $pack, string $actionBy): void
    {
        $pack->setDestroy($actionBy);
        $this->entity_manager->flush();
    }

    /**
     * @param $locationCode
     * @return PackCountDto
     */
    public function getLocationCounts($locationCode): PackCountDto
    {
        $result = $this->packs->generateLocationCounts($locationCode);

        return new PackCountDto(
            $result['location'],
            $result['count'],
            $result['available'],
            $result['deactivated'],
        );
    }
}
