<?php

namespace Atlas\ImpBundle\Service\Allocation;

use Atlas\ImpBundle\Entity\Audit\Imp as Audit;
use DateTimeInterface;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Component\Uid\Uuid;
use Symfony\Component\Validator\Exception\ValidationFailedException;
use Throwable;

readonly class AllocationAuditor
{
    /**
     * @param EntityManagerInterface $entity_manager
     */
    public function __construct(private EntityManagerInterface $entity_manager) {}

    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param string $participantIdentifier
     * @param string $message
     * @param string $actionBy
     * @param Uuid $runId
     * @param DateTimeInterface|null $simulate
     * @param Uuid|null $simulateId
     * @return void
     */
    public function log(
        string $studyCode,
        string $impCode,
        string $participantIdentifier,
        string $message,
        string $actionBy,
        Uuid $runId,
        ?DateTimeInterface $simulate = null,
        ?Uuid $simulateId = null
    ): void
    {
        $audit = new Audit($studyCode, $impCode, $participantIdentifier, $message, $actionBy, $runId, simulation: $simulate, simulationId: $simulateId);

        $this->entity_manager->persist($audit);
        $this->entity_manager->flush();
    }
}
