<?php
declare(strict_types=1);

namespace Atlas\ImpBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\Config\FileLocator;

final class ImpExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yaml');
    }

    public function prepend(ContainerBuilder $container): void
    {
        if (!$this->isEnabled($container)) {
            return;
        }

        $container->prependExtensionConfig('doctrine', [
            'orm' => [
                'mappings' => [
                    'AtlasImp' => [
                        'is_bundle' => false,
                        'type' => 'attribute',
                        'dir' => __DIR__.'/../Entity',
                        'prefix' => 'Atlas\ImpBundle\Entity',
                        'alias' => 'AtlasImp',
                    ],
                ],
            ],
        ]);
    }

    private function isEnabled(ContainerBuilder $container): bool
    {
        $raw = $container->resolveEnvPlaceholders('%env(json:SHARED_IMP_ENABLED)%', true);

        if (!$raw) {
            return false;
        }

        if (is_string($raw)) {
            $list = json_decode($raw, true);
        } else {
            $list = $raw;
        }

        if (!is_array($list)) {
            return false;
        }

        return true;
    }
}
