<?php

namespace Atlas\ImpBundle\Domain;

use Atlas\ImpBundle\Exception\SpecificationException;

final readonly class AlgorithmVariable
{

    private(set) string $name;
    private(set) string $variable;
    private(set) bool $required;

    public function __construct(
        string $name,
        string $variable,
        bool $required,
        int $key
    )
    {
        $name = mb_trim($name, encoding: 'UTF-8');
        if ($name === '') {
            throw new SpecificationException(sprintf('variables[%s].name must not be empty', $key));
        }

        $this->name = $name;

        $variable = mb_trim($variable, encoding: 'UTF-8');
        if ($variable === '') {
            throw new SpecificationException(sprintf('variables[%s].variable must not be empty', $key));
        }

        $this->variable = $variable;

        $this->required = $required;
    }
}