<?php

namespace Atlas\ImpBundle\Repository\Imp;

use Atlas\ImpBundle\Entity\Imp\Enum\PackLocation;
use Atlas\ImpBundle\Entity\Imp\Enum\PackStatus;
use Atlas\ImpBundle\Entity\Imp\Pack;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Pack>
 */
class PackRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Pack::class);
    }

    /**
     * Return counts for a location:
     *  - total packs at the location
     *  - available (= IN)
     *  - deactivated (= DESTROY)
     */
    public function generateLocationCounts(int $locationCode): array
    {
        $qb = $this->createQueryBuilder('p');

        $qb
            ->select(
                'COUNT(p.id) AS total',
                'SUM(CASE WHEN p.status = :statusIn THEN 1 ELSE 0 END) AS available',
                'SUM(CASE WHEN p.status = :statusDestroy THEN 1 ELSE 0 END) AS deactivated'
            )
            ->where('p.location_code = :locationCode')
            ->andWhere('p.location = :location')
            ->setParameter('locationCode', $locationCode)
            ->setParameter('location', PackLocation::LOCATION)
            ->setParameter('statusIn', PackStatus::IN)
            ->setParameter('statusDestroy', PackStatus::DESTROY);

        $result = $qb->getQuery()->getSingleResult();

        return [
            'location' => $locationCode,
            'count' => (int) $result['total'],
            'available' => (int) $result['available'],
            'deactivated' => (int) $result['deactivated'],
        ];
    }
}
