<?php

namespace Atlas\ImpBundle\Service\Allocation;

use Atlas\ImpBundle\Dto\AllocationDto;
use Atlas\ImpBundle\Repository\Allocation\AllocationRepository;
use Atlas\ImpBundle\Service\Specification\SpecificationLoader;
use Psr\Cache\InvalidArgumentException;

readonly class AllocationManager
{
    public function __construct(
        private AllocationRepository $allocations,
        private SpecificationLoader $specification_loader,
    ) {}

    /**
     * @param string $studyCode
     * @param string $impCode
     * @param string $participantIdentifier
     * @param bool $blinded
     * @param int|null $version
     *
     * @return array<int, AllocationDto>
     * @throws InvalidArgumentException
     */
    public function getParticipantAllocations(
        string $studyCode,
        string $impCode,
        string $participantIdentifier,
        bool $blinded = true,
        ?int $version = null,
    ): array {
        $rows = $this->allocations->findByParticipantAllocations(
            $studyCode,
            $impCode,
            $participantIdentifier,
        );

        if ($rows === []) {
            return [];
        }

        $specification = null;
        if (!$blinded) {
            $specification = $this->specification_loader->load(
                $studyCode,
                $impCode,
                version: $version,
            );
        }

        $allocations = [];

        foreach ($rows as $row) {
            $label = $row['pack_label']; // string by invariant

            $allocations[] = new AllocationDto(
                imp_code: $row['imp_code'],
                imp_name: $row['imp_name'],
                pack_identifier: $row['pack_identifier'],
                pack_label: $blinded ? null : ($specification->label_map[$label] ?? $label),
                allocated: $row['allocated'],
                allocated_by: $row['allocated_by'],
            );
        }

        return $allocations;
    }
}