<?php

namespace Atlas\ImpBundle\Repository\Allocation;

use Atlas\ImpBundle\Entity\Allocation\Allocation;
use Atlas\ImpBundle\Entity\Allocation\Sequence;
use Atlas\ImpBundle\Entity\Imp\Enum\PackLocation;
use Atlas\ImpBundle\Entity\Imp\Enum\PackStatus;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Allocation>
 */
class SequenceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Sequence::class);
    }

    public function findUnallocatedSequences(
        string $studyCode,
        string $impCode,
        array $blocks,
        string $label,
        ?string $locationCode = null,
        ?PackLocation $location = PackLocation::LOCATION,
        ?PackStatus $status = PackStatus::IN
    ): array {
        if ($blocks === []) {
            return [];
        }

        $qb = $this->createQueryBuilder('s')
            ->innerJoin('s.pack', 'p')
            ->where('s.study_code = :study')
            ->andWhere('s.imp_code = :imp')
            ->andWhere('s.allocated IS NULL')
            ->andWhere('s.block IN (:blocks)')
            ->andWhere('p.label = :label')
            ->setParameter('study', $studyCode)
            ->setParameter('imp', $impCode)
            ->setParameter('blocks', $blocks)
            ->setParameter('label', $label)
            ->orderBy('s.block', 'ASC')
            ->addOrderBy('s.sequence', 'ASC');

        // Optional location filter
        if ($location !== null) {
            $qb->andWhere('p.location = :loc')
                ->setParameter('loc', $location);
        }

        // Optional status filter
        if ($status !== null) {
            $qb->andWhere('p.status = :stat')
                ->setParameter('stat', $status);
        }

        // Location logic
        if ($locationCode === null) {
            $qb->andWhere('s.location_code IS NULL');
        } else {
            $qb->andWhere('(s.location_code = :location OR s.location_code IS NULL)')
                ->setParameter('location', $locationCode);
        }

        return $qb->getQuery()->getResult();
    }

    public function findFirstUnallocatedSequence(
        string $studyCode,
        string $impCode,
        array $blocks,
        string $label,
        ?string $locationCode = null,
        ?PackLocation $location = PackLocation::LOCATION,
        ?PackStatus $status = PackStatus::IN
    ): ?Sequence {
        if ($blocks === []) {
            return null;
        }

        $qb = $this->createQueryBuilder('s')
            ->innerJoin('s.pack', 'p')
            ->where('s.study_code = :study')
            ->andWhere('s.imp_code = :imp')
            ->andWhere('s.allocated IS NULL')
            ->andWhere('s.block IN (:blocks)')
            ->andWhere('p.label = :label')
            ->setParameter('study', $studyCode)
            ->setParameter('imp', $impCode)
            ->setParameter('blocks', $blocks)
            ->setParameter('label', $label)
            ->orderBy('s.block', 'ASC')
            ->addOrderBy('s.sequence', 'ASC')
            ->setMaxResults(1);

        if ($location !== null) {
            $qb->andWhere('p.location = :loc')
                ->setParameter('loc', $location);
        }

        if ($status !== null) {
            $qb->andWhere('p.status = :stat')
                ->setParameter('stat', $status);
        }

        if ($locationCode === null) {
            $qb->andWhere('s.location_code IS NULL');
        } else {
            $qb->andWhere('(s.location_code = :location OR s.location_code IS NULL)')
                ->setParameter('location', $locationCode);
        }

        return $qb->getQuery()->getOneOrNullResult();
    }

}
