<?php

namespace Atlas\ImpBundle\Domain;

use Atlas\ImpBundle\Entity\Imp\Enum\PackLocation;
use Atlas\ImpBundle\Entity\Imp\Enum\PackStatus;
use Atlas\ImpBundle\Exception\SpecificationException;
use Atlas\ImpBundle\Domain\Enum\AllocationMethod;
use ValueError;

final readonly class AllocationConfiguration
{
    private(set) AllocationMethod $method;
    private(set) PackStatus $status;
    private(set) PackLocation $location;

    public function __construct(
        string $method,
        int $status,
        int $location
    )
    {

        $method = mb_trim($method, encoding: 'UTF-8');
        if ($method === '') {
            throw new SpecificationException('allocations.method must not be empty');
        }

        try {
            $this->method = AllocationMethod::from($method);
        }
        catch (ValueError) {
            throw new SpecificationException('allocations.method does not exist');
        }

        try {
            $this->location = PackLocation::from($location);
        }
        catch (ValueError) {
            throw new SpecificationException('allocations.location does not exist');
        }

        try {
            $this->status = PackStatus::from($status);
        }
        catch (ValueError) {
            throw new SpecificationException('allocations.status does not exist');
        }
    }
}