<?php

namespace Atlas\ImpBundle\Twig;

use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use Symfony\Component\DependencyInjection\Attribute\Autowire;
use Twig\Extension\AbstractExtension;
use Twig\Extension\GlobalsInterface;

#[AutoconfigureTag('twig.extension')]
final class ImpGlobalsExtension extends AbstractExtension implements GlobalsInterface
{
    public function __construct(
        #[Autowire('%imp.enabled%')]
        private readonly bool $enabled
    ) {}

    public function getGlobals(): array
    {
        return [
            'imp_enabled' => $this->enabled
        ];
    }
}
