<?php
declare(strict_types=1);

namespace Atlas\ImpBundle\Exception;

use Throwable;

final class NoUpdateRequiredException extends BundleException
{
    public function __construct(string $message = 'No update required', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function forId(string $type, int $id): self
    {
        return new self(sprintf('No update required for %s with id %s', $type, $id));
    }
}
