<?php

namespace Atlas\ImpBundle\Repository\Imp;

use Atlas\ImpBundle\Entity\Imp\Allocation;
use Atlas\ImpBundle\Entity\Study\Imp;
use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;

/**
 * @extends ServiceEntityRepository<Allocation>
 */
class AllocationRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Allocation::class);
    }

    /**
     * Return participant allocations as scalar rows.
     *
     * @param string $studyCode Study code
     * @param string $participantIdentifier Participant identifier
     * @return array<int, array{
     *     study_code: string,
     *     imp_code: string,
     *     imp_name: string,
     *     pack_label: string,
     *     pack_identifier: string,
     *     allocated: \DateTimeImmutable,
     *     allocated_by: string
     * }>
     */
    public function findByParticipantAllocations(
        string $studyCode,
        string $participantIdentifier,
    ): array {
        /** @var array<int, array{
         *     study_code: string,
         *     imp_code: string,
         *     version: int,
         *     imp_name: string,
         *     pack_label: string,
         *     pack_identifier: string,
         *     allocated: \DateTimeImmutable,
         *     allocated_by: string
         * }> $rows
         */
        $rows = $this->createQueryBuilder('a')
            ->innerJoin('a.pack', 'p')
            ->innerJoin(
                Imp::class,
                'i',
                'WITH',
                'i.study_code = a.study_code AND i.code = a.imp_code'
            )
            ->select([
                'a.study_code AS study_code',
                'a.imp_code AS imp_code',
                'a.version AS version',
                'i.name AS imp_name',
                'p.label AS pack_label',
                'p.pack_identifier AS pack_identifier',
                'a.allocated AS allocated',
                'a.allocated_by AS allocated_by',
            ])
            ->andWhere('a.study_code = :study_code')
            ->andWhere('a.participant_identifier = :participant_identifier')
            ->setParameter('study_code', $studyCode)
            ->setParameter('participant_identifier', $participantIdentifier)
            ->orderBy('a.allocated', 'DESC')
            ->getQuery()
            ->getArrayResult();

        return $rows;
    }
}
