<?php

namespace Atlas\ImpBundle\Contract;

use Atlas\ImpBundle\Domain\Specification;
use Atlas\ImpBundle\Entity\Allocation\Allocation;
use Atlas\ImpBundle\Exception\AllocationException;

use DateTimeInterface;
use Symfony\Component\Uid\Uuid;

interface AlgorithmInterface
{

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $studyCode
     * @param Specification $spec
     * @param string $participantIdentifier
     * @param string $locationCode
     * @param array $variables
     * @param string $actionBy
     * @param DateTimeInterface|null $simulate = null
     * @param Uuid|null $simulationId
     * @return string|false
     * @throws AllocationException
     */
    public function allocate(
        string $studyCode,
        Specification $spec,
        string $participantIdentifier,
        string $locationCode,
        array $variables,
        string $actionBy,
        ?DateTimeInterface $simulate = null,
        ?Uuid $simulationId = null
    ): Allocation|false;
}
