<?php
declare(strict_types=1);

namespace Modules\FrontendJs\Tests\DependencyInjection;

use Modules\FrontendJs\DependencyInjection\FrontendJsExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;

final class FrontendJsExtensionTest extends TestCase
{
    public function test_prepend_adds_asset_mapper_paths_when_framework_extension_exists(): void
    {
        $container = new ContainerBuilder();
        $container->registerExtension(new class extends Extension {
            public function load(array $configs, ContainerBuilder $container): void {}
            public function getAlias(): string { return 'framework'; }
        });

        $ext = new FrontendJsExtension();
        $ext->prepend($container);

        $configs = $container->getExtensionConfig('framework');
        self::assertNotEmpty($configs);
        self::assertArrayHasKey('asset_mapper', $configs[0]);
        self::assertArrayHasKey('paths', $configs[0]['asset_mapper']);
    }

    public function test_prepend_adds_controller_paths_when_stimulus_extension_exists(): void
    {
        $container = new ContainerBuilder();
        $container->registerExtension(new class extends Extension {
            public function load(array $configs, ContainerBuilder $container): void {}
            public function getAlias(): string { return 'stimulus'; }
        });

        $ext = new FrontendJsExtension();
        $ext->prepend($container);

        $configs = $container->getExtensionConfig('stimulus');
        self::assertNotEmpty($configs);
        self::assertArrayHasKey('controller_paths', $configs[0]);
        self::assertIsArray($configs[0]['controller_paths']);
        self::assertGreaterThanOrEqual(2, count($configs[0]['controller_paths']));
    }

    public function test_load_is_noop_but_callable(): void
    {
        $container = new ContainerBuilder();
        $ext = new FrontendJsExtension();

        $ext->load([], $container);

        self::assertTrue(true); // just ensures no exception
    }
}