<?php

declare(strict_types=1);

namespace Modules\FrontendJs\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\Extension;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;

final class FrontendJsExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        // if you also want to load services.yaml from your bundle, you can still do it here
    }

    public function prepend(ContainerBuilder $container): void
    {
        // AssetMapper: OK as-is
        if ($container->hasExtension('framework')) {
            $container->prependExtensionConfig('framework', [
                'asset_mapper' => [
                    'paths' => [
                        __DIR__.'/../../assets' => '@atlas/module-frontend-js',
                    ],
                ],
            ]);
        }

        // Stimulus: only for AssetMapper, and *add* to default path
        if ($container->hasExtension('stimulus')) {
            $container->prependExtensionConfig('stimulus', [
                'controller_paths' => [
                    '%kernel.project_dir%/assets/controllers',   // keep app controllers
                    __DIR__.'/../../assets/controllers',         // add bundle controllers
                ],
            ]);
        }

        if ($container->hasExtension('twig')) {
            $container->prependExtensionConfig('twig', [
                'paths' => [
                    __DIR__.'/../../templates' => 'FrontendJs',
                ],
            ]);
        }
    }
}
