import { Controller } from '@hotwired/stimulus';

export default class extends Controller {
    static values = {
        targetSelector: String, // "#participant-transfer-123"
        attr: String,           // "data-live-location-id-param" | "data-live-journey-id-param" | etc
        value: String           // e.g. "42"
    };

    connect() {
        this.onClick = this.handleClick.bind(this);
        this.element.addEventListener('click', this.onClick);
    }

    disconnect() {
        this.element.removeEventListener('click', this.onClick);
    }

    handleClick() {
        const target = document.querySelector(this.targetSelectorValue);
        if (target && this.attrValue) {
            target.setAttribute(this.attrValue, String(this.valueValue ?? ''));
        }
        // Intentionally do not preventDefault:
        // - keeps Bootstrap's modal triggers working
        // - keeps native <button type="submit"> behaviour if you ever use it that way
    }
}
