<?php
declare(strict_types=1);

namespace Modules\PocockSimon\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Modules\PocockSimon\Entity\Total;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

/**
 * @extends ServiceEntityRepository<Total>
 */
class TotalRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Total::class);
    }

    /**
     * @return array<int,array{
     *   participant_identifier:string,
     *   run_id:string,
     *   arm:string,
     *   total:int
     * }>
     */
    public function exportRows(string $study, string $rand, ?Uuid $sim): array
    {
        $qb = $this->createQueryBuilder('t'); // <-- alias REQUIRED

        $qb->select(
            't.participant_identifier AS participant_identifier',
            't.run_id                 AS run_id',
            't.arm                    AS arm',
            't.total                  AS total'
        )
            ->where('t.study_code = :study')
            ->andWhere('t.randomisation_code = :rand')
            ->andWhere('( (t.simulation_id IS NULL AND :sim IS NULL) OR (t.simulation_id = :sim) )')
            ->setParameter('study', $study)
            ->setParameter('rand', $rand)
            ->setParameter('sim', $sim, UuidType::NAME)
            ->orderBy('t.run_id', 'ASC')
            ->addorderBy('t.participant_identifier', 'ASC')
            ->addOrderBy('t.arm', 'ASC');

        return $qb->getQuery()->getArrayResult();
    }
}
