<?php
declare(strict_types=1);

namespace Modules\PocockSimon\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Modules\PocockSimon\Entity\Hypothetical;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

/**
 * @extends ServiceEntityRepository<Hypothetical>
 */
class HypotheticalRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Hypothetical::class);
    }

    /**
     * @return array<int,array{
     *   participant_identifier:string,
     *   run_id:string,
     *   arm:string,
     *   factor:string,
     *   value:string|null,
     *   count:int,
     *   hypothetical:int,
     *   factor_score:int
     * }>
     */
    public function exportRows(string $study, string $rand, ?Uuid $sim): array
    {
        $qb = $this->createQueryBuilder('h'); // <-- alias REQUIRED

        $qb->select(
            'h.participant_identifier AS participant_identifier',
            'h.run_id                 AS run_id',
            'h.arm                    AS arm',
            'h.factor                 AS factor',
            'h.value                  AS value',
            'h.count                  AS count',
            'h.hypothetical           AS hypothetical',
            'h.total                  AS factor_score'
        )
            ->where('h.study_code = :study')
            ->andWhere('h.randomisation_code = :rand')
            ->andWhere('( (h.simulation_id IS NULL AND :sim IS NULL) OR (h.simulation_id = :sim) )')
            ->setParameter('study', $study)
            ->setParameter('rand', $rand)
            ->setParameter('sim', $sim, UuidType::NAME)
            ->orderBy('h.run_id', 'ASC')
            ->addOrderBy('h.participant_identifier', 'ASC')
            ->addOrderBy('h.arm', 'ASC')
            ->addOrderBy('h.factor', 'ASC')
            ->addOrderBy('h.value', 'ASC');

        return $qb->getQuery()->getArrayResult();
    }
}
