<?php
declare(strict_types=1);

namespace Modules\Simple\DependencyInjection;

use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

final class SimpleExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yaml');
    }

    public function prepend(ContainerBuilder $container): void
    {
        if (!$this->isEnabled($container)) {
            return;
        }

        $container->prependExtensionConfig('doctrine', [
            'orm' => ['mappings' => [
                'Simple' => [
                    'is_bundle' => false,
                    'type' => 'attribute',
                    'dir' => \dirname(__DIR__).'/Entity',
                    'prefix' => 'Modules\\Simple\\Entity',
                ],
            ]],
        ]);

        $container->prependExtensionConfig('doctrine_migrations', [
            'migrations_paths' => [
                'Modules\\Simple\\Migrations' => \dirname(__DIR__).'/migrations',
            ],
        ]);
    }

    private function isEnabled(ContainerBuilder $container): bool
    {
        $list = $container->hasParameter('shared.randomisation.enabled')
            ? (array) $container->getParameter('shared.randomisation.enabled')
            : [];
        return in_array('simple', $list, true);
    }
}
