<?php

declare(strict_types=1);

namespace Modules\Simple\Service;


use Atlas\RandomisationBundle\Contract\ReportInterface;
use Atlas\RandomisationBundle\Contract\SpecificationInterface;
use Atlas\ReportRenderBundle\Model\SectionInterface;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use Symfony\Component\Uid\Uuid;

#[AutoconfigureTag('atlas.randomisation.reporter', attributes: ['algorithm' => 'simple'])]
readonly class Reporter implements ReportInterface
{

    public function getType(): string
    {
        return 'simple';
    }

    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param SpecificationInterface|null $specification
     * @param Uuid|null $simulated
     * @return SectionInterface[]
     */
    public function buildAlgorithmSections(string $studyCode, string $randomisationCode, ?SpecificationInterface $specification = null, ?Uuid $simulated = null): array
    {
        return [];
    }
}