<?php

declare(strict_types=1);

namespace Modules\Simple\Service;


use Atlas\RandomisationBundle\Contract\ExportInterface;
use Atlas\RandomisationBundle\Exception\ExportException;
use Symfony\Component\DependencyInjection\Attribute\AutoconfigureTag;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Uid\Uuid;

#[AutoconfigureTag('atlas.randomisation.exporter', attributes: ['algorithm' => 'simple'])]
readonly class Exporter implements ExportInterface
{

    public function getType(): string
    {
        return 'simple';
    }

    public function getAvailableExports(): array
    {
        return [];
    }

    public function export(string $studyCode, string $randomisationCode, string $exportType, string $method = self::CSV, ?Uuid $simulated = null): Response
    {
        throw new ExportException('No additional exports available for simple randomisation.');
    }
}