<?php
declare(strict_types=1);

namespace Modules\Simple\Tests\DependencyInjection;

use Modules\Simple\DependencyInjection\SimpleExtension;
use PHPUnit\Framework\TestCase;
use Symfony\Component\DependencyInjection\ContainerBuilder;

final class SimpleExtensionTest extends TestCase
{
    public function testLoadRegistersServices(): void
    {
        $container = new ContainerBuilder();
        $container->setParameter('kernel.project_dir', \dirname(__DIR__, 2));

        $ext = new SimpleExtension();
        $ext->load([], $container);

        self::assertTrue($container->hasDefinition('Modules\\Simple\\Service\\Algorithm'));
        self::assertTrue($container->hasDefinition('Modules\\Simple\\Service\\Parser'));
        self::assertTrue($container->hasDefinition('Modules\\Simple\\Service\\Exporter'));
        self::assertTrue($container->hasDefinition('Modules\\Simple\\Service\\Reporter'));
    }

    public function testPrependDoesNothingWhenAlgorithmNotEnabled(): void
    {
        $container = new ContainerBuilder();
        $ext = new SimpleExtension();

        $_ENV['RANDOMISATION_ENABLED'] = '0';
        $_ENV['RANDOMISATION_ALGS'] = '["simple"]';

        $ext->prepend($container);

        self::assertSame([], $container->getExtensionConfig('doctrine'));
    }
}