<?php

declare(strict_types=1);

namespace Atlas\PdfGeneratorBundle\Tests\Service;

use Atlas\PdfGeneratorBundle\Service\PdfGenerator;
use PHPUnit\Framework\Attributes\AllowMockObjectsWithoutExpectations;
use PHPUnit\Framework\TestCase;
use RuntimeException;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;

#[AllowMockObjectsWithoutExpectations]
final class PdfGeneratorTest extends TestCase
{
    public function testGenerateFromHtmlRejectsEmptyHtml(): void
    {
        $params = $this->createMock(ParameterBagInterface::class);
        $generator = new PdfGenerator($params);

        $this->expectException(RuntimeException::class);
        $this->expectExceptionMessage('Refusing to render empty HTML into PDF');

        $generator->generateFromHtml('   ');
    }

    public function testGenerateFromHtmlThrowsWhenBinaryMissing(): void
    {
        $tmpProjectDir = sys_get_temp_dir() . '/atlas_pdf_gen_' . bin2hex(random_bytes(8));
        @mkdir($tmpProjectDir, 0777, true);

        $params = $this->createMock(ParameterBagInterface::class);
        $params->method('get')->with('kernel.project_dir')->willReturn($tmpProjectDir);

        $generator = new PdfGenerator($params);

        $this->expectException(RuntimeException::class);
        $this->expectExceptionMessage('wkhtmltopdf binary not found or not executable');

        $generator->generateFromHtml('<html><body>Hello</body></html>');
    }
}