<?php

namespace Atlas\RandomisationBundle\Contract;

use Atlas\RandomisationBundle\Dto\ExportTypeDto;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Uid\Uuid;

interface ExportInterface
{
    public const string EXCEL = 'excel';
    public const string CSV = 'csv';
    public const string SPSS = 'spss';

    /**
     * @return ExportTypeDto[]
     */
    public function getAvailableExports(): array;

    /**
     * @param string $studyCode
     * @param string $randomisationCode
     * @param string $exportType if null always produces allocation list
     * @param string $method
     * @param Uuid|null $simulated
     * @return Response
     */
    public function export(string $studyCode, string $randomisationCode, string $exportType, string $method = self::CSV, ?Uuid $simulated = null): Response;

    /**
     * This is the type of randomisation
     *
     * @return string
     */
    public function getType(): string;
}