<?php
declare(strict_types=1);

namespace Atlas\RandomisationBundle\DependencyInjection;

use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\Config\FileLocator;

final class RandomisationExtension extends Extension implements PrependExtensionInterface
{
    public function load(array $configs, ContainerBuilder $container): void
    {
        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../../config'));
        $loader->load('services.yaml');
    }

    public function prepend(ContainerBuilder $container): void
    {
        $container->prependExtensionConfig('doctrine', [
            'orm' => [
                'mappings' => [
                    'AtlasRandomisation' => [
                        'is_bundle' => false,
                        'type' => 'attribute',
                        'dir' => __DIR__.'/../Entity',
                        'prefix' => 'Atlas\RandomisationBundle\Entity',
                        'alias' => 'AtlasRandomisation',
                    ],
                ],
            ],
        ]);

        $container->prependExtensionConfig('twig', [
            'paths' => [
                // path => namespace
                __DIR__ . '/../../templates' => 'Randomisation',
            ],
        ]);
    }

}
