<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Domain;

use Atlas\RandomisationBundle\Exception\SpecificationException;

readonly class Arm
{
    private(set) string $arm;
    private(set) int $weight;
    private(set) int|string|null $export;

    /**
     * @param string $arm
     * @param int $weight
     * @param int $key
     * @param int|string|null $export
     */
    public function __construct(
        string $arm,
        int $weight,
        int $key,
        int|string|null $export = null
    )
    {
        if(empty($arm = mb_trim($arm, encoding: 'UTF-8'))) {
            throw new SpecificationException(sprintf('randomisation.arms[%s] arm must not be empty',$key));
        }

        if($weight < 1) {
            throw new SpecificationException(sprintf('randomisation.arms[%s] weighting must be >= 1',$key));
        }

        if(is_string($export)) {
            if(empty($export = mb_trim($export, encoding: 'UTF-8'))) {
                throw new SpecificationException(sprintf('randomisation.arms[%s].export must not be empty',$key));
            }
        }

        $this->arm = $arm;
        $this->weight = $weight;
        $this->export = $export;

    }
}
