<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Exception;

use Throwable;

final class SpecificationException extends BundleException
{
    public function __construct(string $message = 'Specification error', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function noSpecification(string $path): self
    {
        return new self(sprintf('Specification not found for: %s', $path));
    }

    public static function invalidFormat(string $path): self
    {
        return new self(sprintf('Invalid specification file format: %s (expected an array)', $path));
    }
}

