<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Exception;

use Throwable;

final class NotBlankException extends BundleException
{
    public function __construct(string $message = 'Field cannot be blank', int $code = 0, ?Throwable $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }

    public static function name(string $name): self
    {
        return new self(sprintf('%s cannot be blank', $name));
    }
}

