<?php

declare(strict_types=1);

namespace Atlas\RandomisationBundle\Contract;

use Atlas\RandomisationBundle\Dto\RandomisationResultDto;
use Atlas\RandomisationBundle\Exception\RandomisationException;
use DateTimeInterface;
use Symfony\Component\Uid\Uuid;

interface AlgorithmInterface
{

    /**
     * @return string
     */
    public function getType(): string;

    /**
     * @param string $studyCode
     * @param string $randomisationName
     * @param SpecificationInterface $specification
     * @param string $participantIdentifier
     * @param string $location
     * @param string $actionBy
     * @param array $variables
     * @param DateTimeInterface|null $simulate = null
     * @param Uuid|null $simulateId
     * @return RandomisationResultDto|false
     * @throws RandomisationException
     */
    public function randomise(
        string $studyCode,
        string $randomisationName,
        SpecificationInterface $specification,
        string $participantIdentifier,
        string $location,
        string $actionBy,
        array $variables = [],
        ?DateTimeInterface $simulate = null,
        ?Uuid $simulateId = null,
    ): RandomisationResultDto|false;
}
